/*
 * Decompiled with CFR 0.152.
 */
package ec.gob.sri.dimm.ats.ui.asistentes.paginas.compras;

import ec.gob.sri.dimm.api.colecciones.ElementoNombreValor;
import ec.gob.sri.dimm.api.convertidores.BooleanNegativeConverter;
import ec.gob.sri.dimm.api.modelo.ObjetoModelo;
import ec.gob.sri.dimm.api.modelo.validacion.ContextoValidacion;
import ec.gob.sri.dimm.api.modelo.validacion.InformacionValidableContexto;
import ec.gob.sri.dimm.api.modelo.validacion.ListenerValidacionModeloPaginaAsistente;
import ec.gob.sri.dimm.api.ui.VistaModelo;
import ec.gob.sri.dimm.api.ui.VistaValoresPropios;
import ec.gob.sri.dimm.api.ui.asistentes.PaginaAsistente;
import ec.gob.sri.dimm.api.ui.util.controles.AyudanteComposite;
import ec.gob.sri.dimm.api.ui.util.controles.AyudanteViewer;
import ec.gob.sri.dimm.api.ui.util.eventos.AyudanteSelectionChangedEvent;
import ec.gob.sri.dimm.ats.modelo.obj.Periodo;
import ec.gob.sri.dimm.ats.modelo.obj.asistente.recap.valores.ModeloValoresPagoLocal;
import ec.gob.sri.dimm.ats.modelo.obj.compras.TransaccionCompra;
import ec.gob.sri.dimm.ats.modelo.util.InfoPantallas;
import ec.gob.sri.dimm.ats.ui.asistentes.paginas.compras.ComponenteFiscalidad;
import java.beans.PropertyChangeListener;
import org.eclipse.core.databinding.DataBindingContext;
import org.eclipse.core.databinding.UpdateValueStrategy;
import org.eclipse.core.databinding.beans.BeanProperties;
import org.eclipse.core.databinding.beans.BeansObservables;
import org.eclipse.core.databinding.beans.PojoObservables;
import org.eclipse.core.databinding.beans.PojoProperties;
import org.eclipse.core.databinding.conversion.IConverter;
import org.eclipse.core.databinding.observable.list.IObservableList;
import org.eclipse.core.databinding.observable.map.IObservableMap;
import org.eclipse.core.databinding.observable.set.IObservableSet;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.jface.databinding.swt.ISWTObservableValue;
import org.eclipse.jface.databinding.swt.SWTObservables;
import org.eclipse.jface.databinding.swt.WidgetProperties;
import org.eclipse.jface.databinding.viewers.ObservableListContentProvider;
import org.eclipse.jface.databinding.viewers.ObservableMapLabelProvider;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.nebula.widgets.cdatetime.CDateTime;
import org.eclipse.swt.events.FocusAdapter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.wb.swt.SWTResourceManager;

public class PaginaPagoLocal
extends PaginaAsistente
implements VistaModelo<TransaccionCompra>,
VistaValoresPropios {
    private DataBindingContext m_bindingContext;
    private boolean editando;
    private TransaccionCompra modeloDatos;
    private ModeloValoresPagoLocal modeloValores;
    private Text txtEstablecimiento;
    private Text txtPuntoEmision;
    private Text txtSecuencial;
    private Text txtNumAutorizacion;
    private Button btnConvenioSi;
    private Button btnConvenioNo;
    private Label lblPagoAResidente;
    private Button btnRegPreferenteSi;
    private Button btnRegPreferenteNo;
    private Button btnRetencionSi;
    private Button btnRetencionNo;
    private ComboViewer cvPagoLocalExterior;
    private Composite compositeSerial;
    private Composite compositeComp;
    private Combo cmbPago;
    private Button btnObligatorio;
    private final Periodo periodo;
    private ComponenteFiscalidad compFiscalidad;

    public PaginaPagoLocal(boolean editando, Periodo periodo) {
        super(PaginaPagoLocal.class.getName(), "Anexo Transaccional", "Especifique la informaci\u00f3n correspondiente");
        this.periodo = periodo;
        this.setTitle("Comprobante de Retenci\u00f3n");
        this.editando = editando;
    }

    public void inicializarModeloValores() {
        this.modeloValores = new ModeloValoresPagoLocal(this.periodo.getFechaDeclarada());
        this.modeloValores.inicializaPeriodo(this.periodo);
        this.modeloValores.inicializar();
    }

    public void setModeloDatos(TransaccionCompra modeloDatos) {
        this.modeloDatos = modeloDatos;
        this.compFiscalidad = new ComponenteFiscalidad(modeloDatos.getPagoLocalExterior(), this.periodo);
    }

    public void procesarModeloDatos() {
        boolean esPagoANoResidente = false;
        String codigoPago = this.modeloDatos.getPagoLocalExterior().getFiscalidad().getTipoPago();
        ElementoNombreValor tipoPago = this.modeloValores.obtenerTipoPago(codigoPago);
        AyudanteViewer.seleccionarElemento((Viewer)this.cvPagoLocalExterior, (Object)tipoPago);
        this.compFiscalidad.inicializarViews();
        if (tipoPago != null) {
            esPagoANoResidente = "02".equals(tipoPago.getValor());
            this.compFiscalidad.determinarTipoRegimen();
        }
        this.habilitarSeccionConvenioYRetencionParaPagoExterior(esPagoANoResidente);
        this.setPageComplete(this.periodo.isPeriodoAnteriorA2013());
        AyudanteComposite.activar((Composite)this.compositeComp, (boolean)this.modeloDatos.getComprobanteRetencion().isObligatorio());
        AyudanteComposite.activar((Composite)this.compositeSerial, (boolean)this.modeloDatos.getComprobanteRetencion().isObligatorio());
        ContextoValidacion ctxVal = new ContextoValidacion().agregar(InfoPantallas.COMPRA_PAGO_LOCAL.toString(), (Object)InfoPantallas.COMPRA_PAGO_LOCAL);
        ListenerValidacionModeloPaginaAsistente listener = new ListenerValidacionModeloPaginaAsistente((InformacionValidableContexto)this.modeloDatos, ctxVal, (PaginaAsistente)this);
        this.modeloDatos.addPropertyChangeListener((PropertyChangeListener)listener);
        this.modeloDatos.getPagoLocalExterior().addPropertyChangeListener((PropertyChangeListener)listener);
        this.modeloDatos.getPagoLocalExterior().getFiscalidad().addPropertyChangeListener((PropertyChangeListener)listener);
        this.modeloDatos.getComprobanteRetencion().addPropertyChangeListener((PropertyChangeListener)listener);
    }

    private void habilitarSeccionConvenioYRetencionParaPagoExterior(boolean esPagoANoResidente) {
        if (this.periodo.isPeriodoDesdeEnero2013()) {
            this.cmbPago.setEnabled(this.periodo.isPeriodoDesdeEnero2013());
            this.btnConvenioSi.setEnabled(esPagoANoResidente);
            this.btnConvenioNo.setEnabled(esPagoANoResidente);
            this.btnRetencionSi.setEnabled(esPagoANoResidente);
            this.btnRetencionNo.setEnabled(esPagoANoResidente);
        }
        this.compFiscalidad.habilitarConvenioYRetencionParaPagoExteriorModoEdicion(esPagoANoResidente);
    }

    public void createControl(Composite parent) {
        Composite container = new Composite(parent, 0);
        this.setControl((Control)container);
        GridLayout gl_container = new GridLayout(2, false);
        gl_container.verticalSpacing = 2;
        container.setLayout((Layout)gl_container);
        Label lblInformacinDelPago = new Label(container, 0);
        GridData gd_lblInformacinDelPago = new GridData(16384, 0x1000000, false, false, 1, 1);
        gd_lblInformacinDelPago.verticalIndent = 2;
        lblInformacinDelPago.setLayoutData((Object)gd_lblInformacinDelPago);
        lblInformacinDelPago.setText("Informaci\u00f3n del Pago");
        lblInformacinDelPago.setFont(SWTResourceManager.getFont((String)".SF NS Text", (int)11, (int)1));
        new Label(container, 0);
        Label lblPagoLocalO = new Label(container, 0);
        lblPagoLocalO.setText("Pago a residente o no residente ");
        this.cvPagoLocalExterior = new ComboViewer(container, 8);
        this.manejarSeleccionCvPagoLocalExterior();
        this.cmbPago = this.cvPagoLocalExterior.getCombo();
        GridData gd_cmbPago = new GridData(16384, 0x1000000, true, false, 1, 1);
        gd_cmbPago.widthHint = 175;
        this.cmbPago.setLayoutData((Object)gd_cmbPago);
        this.compFiscalidad.crearComponenteFiscalidad(container, false);
        boolean verPregunta = this.compFiscalidad.visualizarEnPantalla();
        this.lblPagoAResidente = new Label(container, 0);
        GridData gd_lblPagoAResidente = new GridData(16384, 0x1000000, false, false, 1, 1);
        gd_lblPagoAResidente.widthHint = 342;
        this.lblPagoAResidente.setLayoutData((Object)gd_lblPagoAResidente);
        this.lblPagoAResidente.setText("\u00bfEl pago es a un r\u00e9gimen fiscal preferente o de menor imposici\u00f3n?");
        this.lblPagoAResidente.setVisible(verPregunta);
        Composite compositePagoRegFis = new Composite(container, 0);
        compositePagoRegFis.setLayout((Layout)new GridLayout(2, false));
        this.btnRegPreferenteSi = new Button(compositePagoRegFis, 16);
        this.btnRegPreferenteSi.setVisible(verPregunta);
        GridData gd_btnRegPreferenteSi = new GridData(16384, 0x1000000, false, false, 1, 1);
        gd_btnRegPreferenteSi.widthHint = 50;
        this.btnRegPreferenteSi.setLayoutData((Object)gd_btnRegPreferenteSi);
        this.btnRegPreferenteSi.setText("SI");
        this.btnRegPreferenteNo = new Button(compositePagoRegFis, 16);
        this.btnRegPreferenteNo.setVisible(verPregunta);
        GridData gd_btnRegPreferenteNo = new GridData(16384, 0x1000000, false, false, 1, 1);
        gd_btnRegPreferenteNo.widthHint = 50;
        this.btnRegPreferenteNo.setLayoutData((Object)gd_btnRegPreferenteNo);
        this.btnRegPreferenteNo.setText("NO");
        Label lblAplicaConvenioDoble = new Label(container, 0);
        lblAplicaConvenioDoble.setText("\u00bfAplica convenio de doble tributaci\u00f3n?");
        Composite composite_1 = new Composite(container, 0);
        composite_1.setLayout((Layout)new GridLayout(2, false));
        this.btnConvenioSi = new Button(composite_1, 16);
        this.btnConvenioSi.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDown(MouseEvent e) {
                boolean habilitar = PaginaPagoLocal.this.periodo.isPeriodoDesdeEnero2018();
                PaginaPagoLocal.this.btnRetencionNo.setEnabled(habilitar);
                PaginaPagoLocal.this.btnRetencionSi.setEnabled(habilitar);
            }
        });
        GridData gd_btnConvenioSi = new GridData(16384, 0x1000000, false, false, 1, 1);
        gd_btnConvenioSi.widthHint = 50;
        this.btnConvenioSi.setLayoutData((Object)gd_btnConvenioSi);
        this.btnConvenioSi.setText("SI");
        this.btnConvenioNo = new Button(composite_1, 16);
        this.btnConvenioNo.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDown(MouseEvent e) {
                boolean esPagoANoResidente = "02".equals(PaginaPagoLocal.this.modeloDatos.getPagoLocalExterior().getFiscalidad().getTipoPago());
                boolean habilitar = PaginaPagoLocal.this.periodo.isPeriodoDesdeEnero2013() && esPagoANoResidente;
                PaginaPagoLocal.this.btnRetencionNo.setEnabled(habilitar);
                PaginaPagoLocal.this.btnRetencionSi.setEnabled(habilitar);
            }
        });
        GridData gd_btnConvenioNo = new GridData(16384, 0x1000000, false, false, 1, 1);
        gd_btnConvenioNo.widthHint = 50;
        this.btnConvenioNo.setLayoutData((Object)gd_btnConvenioNo);
        this.btnConvenioNo.setText("NO");
        Label lblPagoRetencion = new Label(container, 0);
        GridData gd_lblPagoRetencion = new GridData(16384, 0x1000000, false, false, 1, 1);
        gd_lblPagoRetencion.widthHint = 310;
        lblPagoRetencion.setLayoutData((Object)gd_lblPagoRetencion);
        lblPagoRetencion.setText("\u00bfPago sujeto a retenci\u00f3n en aplicaci\u00f3n \n de la norma legal?");
        Composite composite = new Composite(container, 0);
        composite.setLayout((Layout)new GridLayout(2, false));
        this.btnRetencionSi = new Button(composite, 16);
        GridData gd_btnRetencionSi = new GridData(16384, 0x1000000, false, false, 1, 1);
        gd_btnRetencionSi.widthHint = 50;
        this.btnRetencionSi.setLayoutData((Object)gd_btnRetencionSi);
        this.btnRetencionSi.setSize(90, 16);
        this.btnRetencionSi.setText("SI");
        this.btnRetencionNo = new Button(composite, 16);
        GridData gd_btnRetencionNo = new GridData(16384, 0x1000000, false, false, 1, 1);
        gd_btnRetencionNo.widthHint = 50;
        this.btnRetencionNo.setLayoutData((Object)gd_btnRetencionNo);
        this.btnRetencionNo.setText("NO");
        Label lblComprobante = new Label(container, 0);
        GridData gd_lblComprobante = new GridData(16384, 0x1000000, false, false, 1, 1);
        gd_lblComprobante.verticalIndent = 6;
        lblComprobante.setLayoutData((Object)gd_lblComprobante);
        lblComprobante.setText("Comprobante de Retenci\u00f3n");
        lblComprobante.setFont(SWTResourceManager.getBoldFont((Font)lblComprobante.getFont()));
        new Label(container, 0);
        Label label = new Label(container, 0);
        label.setText("\u00bfTiene Comprobante de Retenci\u00f3n?");
        this.btnObligatorio = new Button(container, 32);
        this.btnObligatorio.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                AyudanteComposite.activar((Composite)PaginaPagoLocal.this.compositeComp, (boolean)PaginaPagoLocal.this.btnObligatorio.getSelection());
                AyudanteComposite.activar((Composite)PaginaPagoLocal.this.compositeSerial, (boolean)PaginaPagoLocal.this.btnObligatorio.getSelection());
                if (!PaginaPagoLocal.this.btnObligatorio.getSelection()) {
                    PaginaPagoLocal.this.modeloDatos.getComprobanteRetencion().reiniciar();
                }
            }
        });
        this.compositeComp = new Composite(container, 0);
        this.compositeComp.setLayoutData((Object)new GridData(16384, 0x1000000, false, false, 2, 1));
        GridLayout gl_compositeComp = new GridLayout(2, false);
        gl_compositeComp.marginWidth = 0;
        this.compositeComp.setLayout((Layout)gl_compositeComp);
        this.compositeSerial = new Composite(this.compositeComp, 0);
        this.compositeSerial.setLayoutData((Object)new GridData(16384, 0x1000000, false, false, 2, 1));
        GridLayout gl_compositeSerial = new GridLayout(6, false);
        gl_compositeSerial.marginWidth = 0;
        gl_compositeSerial.marginHeight = 0;
        this.compositeSerial.setLayout((Layout)gl_compositeSerial);
        Label lblEstablecimiento = new Label(this.compositeSerial, 0);
        GridData gd_lblEstablecimiento = new GridData(16384, 0x1000000, false, false, 1, 1);
        gd_lblEstablecimiento.widthHint = 90;
        lblEstablecimiento.setLayoutData((Object)gd_lblEstablecimiento);
        lblEstablecimiento.setText("Establecimiento");
        this.txtEstablecimiento = new Text(this.compositeSerial, 2048);
        this.txtEstablecimiento.addFocusListener((FocusListener)new FocusAdapter(){

            public void focusGained(FocusEvent e) {
                PaginaPagoLocal.this.txtEstablecimiento.selectAll();
            }
        });
        this.txtEstablecimiento.setTextLimit(3);
        GridData gd_txtEstablecimiento = new GridData(4, 0x1000000, true, false, 1, 1);
        gd_txtEstablecimiento.widthHint = 100;
        this.txtEstablecimiento.setLayoutData((Object)gd_txtEstablecimiento);
        Label lblPuntoEmisin = new Label(this.compositeSerial, 0);
        GridData gd_lblPuntoEmisin = new GridData(16384, 0x1000000, false, false, 1, 1);
        gd_lblPuntoEmisin.widthHint = 80;
        lblPuntoEmisin.setLayoutData((Object)gd_lblPuntoEmisin);
        lblPuntoEmisin.setText("Punto Emisi\u00f3n");
        this.txtPuntoEmision = new Text(this.compositeSerial, 2048);
        this.txtPuntoEmision.addFocusListener((FocusListener)new FocusAdapter(){

            public void focusGained(FocusEvent e) {
                PaginaPagoLocal.this.txtPuntoEmision.selectAll();
            }
        });
        this.txtPuntoEmision.setTextLimit(3);
        GridData gd_txtPuntoEmision = new GridData(4, 0x1000000, true, false, 1, 1);
        gd_txtPuntoEmision.widthHint = 60;
        this.txtPuntoEmision.setLayoutData((Object)gd_txtPuntoEmision);
        Label lblNSecuencial = new Label(this.compositeSerial, 0);
        GridData gd_lblNSecuencial = new GridData(131072, 0x1000000, false, false, 1, 1);
        gd_lblNSecuencial.widthHint = 80;
        lblNSecuencial.setLayoutData((Object)gd_lblNSecuencial);
        lblNSecuencial.setText("N\u00b0 Secuencial");
        this.txtSecuencial = new Text(this.compositeSerial, 2048);
        this.txtSecuencial.addFocusListener((FocusListener)new FocusAdapter(){

            public void focusGained(FocusEvent e) {
                PaginaPagoLocal.this.txtSecuencial.selectAll();
            }
        });
        this.txtSecuencial.setTextLimit(9);
        GridData gd_txtSecuencial = new GridData(4, 0x1000000, true, false, 1, 1);
        gd_txtSecuencial.widthHint = 90;
        this.txtSecuencial.setLayoutData((Object)gd_txtSecuencial);
        Label lblNAutorizacinComprobante = new Label(this.compositeComp, 0);
        GridData gd_lblNAutorizacinComprobante = new GridData(16384, 0x1000000, false, false, 1, 1);
        gd_lblNAutorizacinComprobante.widthHint = 310;
        lblNAutorizacinComprobante.setLayoutData((Object)gd_lblNAutorizacinComprobante);
        lblNAutorizacinComprobante.setText("N\u00b0 Autorizaci\u00f3n Comprobante");
        this.txtNumAutorizacion = new Text(this.compositeComp, 2048);
        this.txtNumAutorizacion.addFocusListener((FocusListener)new FocusAdapter(){

            public void focusGained(FocusEvent e) {
                PaginaPagoLocal.this.txtNumAutorizacion.selectAll();
            }
        });
        GridData gd_txtNumAutorizacion = new GridData(16384, 0x1000000, false, false, 1, 1);
        gd_txtNumAutorizacion.widthHint = 220;
        this.txtNumAutorizacion.setLayoutData((Object)gd_txtNumAutorizacion);
        this.txtNumAutorizacion.setTextLimit(49);
        Label lblFechaEmisinComprobante = new Label(this.compositeComp, 0);
        lblFechaEmisinComprobante.setText("Fecha Emisi\u00f3n Comprobante");
        final CDateTime dateTime = new CDateTime(this.compositeComp, 32771);
        GridData gd_dateTime = new GridData(16384, 0x1000000, false, false, 1, 1);
        gd_dateTime.widthHint = 125;
        dateTime.setLayoutData((Object)gd_dateTime);
        dateTime.setSelection(this.modeloDatos.getComprobanteRetencion().getFechaEmision());
        dateTime.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                PaginaPagoLocal.this.modeloDatos.getComprobanteRetencion().setFechaEmision(dateTime.getSelection());
            }
        });
        dateTime.setNullText("seleccione la fecha");
        dateTime.setPattern("dd/MM/yyyy");
        this.m_bindingContext = this.initDataBindings();
        this.habilitarDesabilitarRetencion();
        this.procesarModeloDatos();
    }

    private void manejarSeleccionCvPagoLocalExterior() {
        this.cvPagoLocalExterior.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                ElementoNombreValor tipoPago = (ElementoNombreValor)AyudanteSelectionChangedEvent.obtenerValorSeleccionado((SelectionChangedEvent)event);
                if (tipoPago != null) {
                    PaginaPagoLocal.this.modeloDatos.getPagoLocalExterior().getFiscalidad().setTipoPago((String)tipoPago.getValor());
                    PaginaPagoLocal.this.modeloDatos.getPagoLocalExterior().getFiscalidad().setDescripcionTipoPago(tipoPago.getNombre());
                    PaginaPagoLocal.this.determinaSiEsPagoANoResidente((ElementoNombreValor<String>)tipoPago);
                }
            }
        });
    }

    private void determinaSiEsPagoANoResidente(ElementoNombreValor<String> tipoPago) {
        boolean esPagoANoResidente = "02".equals(tipoPago.getValor());
        this.habilitarSeccionPagoExterior(esPagoANoResidente);
    }

    private void habilitarSeccionPagoExterior(boolean esPagoANoResidente) {
        this.btnConvenioSi.setEnabled(esPagoANoResidente);
        this.btnConvenioNo.setEnabled(esPagoANoResidente);
        this.btnRetencionSi.setEnabled(esPagoANoResidente);
        this.btnRetencionNo.setEnabled(esPagoANoResidente);
        if (this.periodo.isAnexoEnPeriodoDesdeMayo2016()) {
            this.lblPagoAResidente.setVisible(false);
            this.btnRegPreferenteSi.setVisible(false);
            this.btnRegPreferenteNo.setVisible(false);
        } else {
            this.lblPagoAResidente.setVisible(esPagoANoResidente && this.periodo.isPeriodoDeAnexoDesdeMarzo2015());
            this.btnRegPreferenteSi.setVisible(esPagoANoResidente && this.periodo.isPeriodoDeAnexoDesdeMarzo2015());
            this.btnRegPreferenteNo.setVisible(esPagoANoResidente && this.periodo.isPeriodoDeAnexoDesdeMarzo2015());
        }
        this.compFiscalidad.habilitarPagoExteriorLuegoDeLaSeleccionDelTipoDePago(esPagoANoResidente);
        this.habilitarDesabilitarRetencion();
    }

    public void habilitarDesabilitarRetencion() {
        boolean habilita = false;
        if (this.btnConvenioSi.getSelection()) {
            habilita = false;
        }
        if (this.btnConvenioNo.getSelection() || this.periodo.isPeriodoDesdeEnero2018()) {
            habilita = true;
        }
        if (!this.periodo.isPeriodoDesdeEnero2018()) {
            this.btnRetencionSi.setEnabled(habilita);
            this.btnRetencionNo.setEnabled(habilita);
        }
    }

    protected DataBindingContext initDataBindings() {
        DataBindingContext bindingContext = new DataBindingContext();
        ObservableListContentProvider listContentProvider = new ObservableListContentProvider();
        IObservableMap observeMap = PojoObservables.observeMap((IObservableSet)listContentProvider.getKnownElements(), ElementoNombreValor.class, (String)"etiqueta");
        this.cvPagoLocalExterior.setLabelProvider((IBaseLabelProvider)new ObservableMapLabelProvider(observeMap));
        this.cvPagoLocalExterior.setContentProvider((IContentProvider)listContentProvider);
        IObservableList tiposPagosModeloValoresObserveList = PojoProperties.list((String)"tiposPagos").observe((Object)this.modeloValores);
        this.cvPagoLocalExterior.setInput((Object)tiposPagosModeloValoresObserveList);
        ISWTObservableValue observeTextTxtEstablecimientoObserveWidget = WidgetProperties.text((int)24).observe((Widget)this.txtEstablecimiento);
        IObservableValue comprobanteRetencionestablecimientoModeloDatosObserveValue = BeanProperties.value((String)"comprobanteRetencion.establecimiento").observe((Object)this.modeloDatos);
        bindingContext.bindValue((IObservableValue)observeTextTxtEstablecimientoObserveWidget, comprobanteRetencionestablecimientoModeloDatosObserveValue, null, null);
        ISWTObservableValue observeTextTxtPuntoEmisionObserveWidget = WidgetProperties.text((int)24).observe((Widget)this.txtPuntoEmision);
        IObservableValue comprobanteRetencionpuntoEmisionModeloDatosObserveValue = BeanProperties.value((String)"comprobanteRetencion.puntoEmision").observe((Object)this.modeloDatos);
        bindingContext.bindValue((IObservableValue)observeTextTxtPuntoEmisionObserveWidget, comprobanteRetencionpuntoEmisionModeloDatosObserveValue, null, null);
        ISWTObservableValue observeTextTxtSecuencialObserveWidget = WidgetProperties.text((int)24).observe((Widget)this.txtSecuencial);
        IObservableValue comprobanteRetencionsecuencialModeloDatosObserveValue = BeanProperties.value((String)"comprobanteRetencion.secuencial").observe((Object)this.modeloDatos);
        bindingContext.bindValue((IObservableValue)observeTextTxtSecuencialObserveWidget, comprobanteRetencionsecuencialModeloDatosObserveValue, null, null);
        ISWTObservableValue observeTextTxtNumAutorizacionObserveWidget = WidgetProperties.text((int)24).observe((Widget)this.txtNumAutorizacion);
        IObservableValue comprobanteRetencionnumAutorizacionModeloDatosObserveValue = BeanProperties.value((String)"comprobanteRetencion.numAutorizacion").observe((Object)this.modeloDatos);
        bindingContext.bindValue((IObservableValue)observeTextTxtNumAutorizacionObserveWidget, comprobanteRetencionnumAutorizacionModeloDatosObserveValue, null, null);
        ISWTObservableValue observeSelectionBtnConvenioSiObserveWidget = WidgetProperties.selection().observe((Widget)this.btnConvenioSi);
        IObservableValue pagoLocalExteriorconvenioDobleTributacionModeloDatosObserveValue = BeanProperties.value((String)"pagoLocalExterior.convenioDobleTributacion").observe((Object)this.modeloDatos);
        bindingContext.bindValue((IObservableValue)observeSelectionBtnConvenioSiObserveWidget, pagoLocalExteriorconvenioDobleTributacionModeloDatosObserveValue, null, null);
        ISWTObservableValue observeSelectionBtnConvenioNoObserveWidget = WidgetProperties.selection().observe((Widget)this.btnConvenioNo);
        UpdateValueStrategy strategy = new UpdateValueStrategy();
        strategy.setConverter((IConverter)new BooleanNegativeConverter());
        UpdateValueStrategy strategy_1 = new UpdateValueStrategy();
        strategy_1.setConverter((IConverter)new BooleanNegativeConverter());
        bindingContext.bindValue((IObservableValue)observeSelectionBtnConvenioNoObserveWidget, pagoLocalExteriorconvenioDobleTributacionModeloDatosObserveValue, strategy, strategy_1);
        ISWTObservableValue observeSelectionBtnRetencionSiObserveWidget = WidgetProperties.selection().observe((Widget)this.btnRetencionSi);
        IObservableValue pagoLocalExteriorsujetoNormaLegalModeloDatosObserveValue = BeanProperties.value((String)"pagoLocalExterior.sujetoNormaLegal").observe((Object)this.modeloDatos);
        bindingContext.bindValue((IObservableValue)observeSelectionBtnRetencionSiObserveWidget, pagoLocalExteriorsujetoNormaLegalModeloDatosObserveValue, null, null);
        ISWTObservableValue observeSelectionBtnRetencionNoObserveWidget = WidgetProperties.selection().observe((Widget)this.btnRetencionNo);
        UpdateValueStrategy strategy_2 = new UpdateValueStrategy();
        strategy_2.setConverter((IConverter)new BooleanNegativeConverter());
        UpdateValueStrategy strategy_3 = new UpdateValueStrategy();
        strategy_3.setConverter((IConverter)new BooleanNegativeConverter());
        bindingContext.bindValue((IObservableValue)observeSelectionBtnRetencionNoObserveWidget, pagoLocalExteriorsujetoNormaLegalModeloDatosObserveValue, strategy_2, strategy_3);
        ISWTObservableValue observeSelectionBtnObligatorioObserveWidget = WidgetProperties.selection().observe((Widget)this.btnObligatorio);
        IObservableValue comprobanteRetencionobligatorioModeloDatosObserveValue = BeanProperties.value((String)"comprobanteRetencion.obligatorio").observe((Object)this.modeloDatos);
        bindingContext.bindValue((IObservableValue)observeSelectionBtnObligatorioObserveWidget, comprobanteRetencionobligatorioModeloDatosObserveValue, null, null);
        ISWTObservableValue btnRegPreferenteSiObserveSelectionObserveWidget = SWTObservables.observeSelection((Control)this.btnRegPreferenteSi);
        IObservableValue modeloDatosPagoLocalExteriorpagoRegimenFiscalObserveValue = BeansObservables.observeValue((Object)this.modeloDatos, (String)"pagoLocalExterior.pagoRegimenFiscal");
        bindingContext.bindValue((IObservableValue)btnRegPreferenteSiObserveSelectionObserveWidget, modeloDatosPagoLocalExteriorpagoRegimenFiscalObserveValue, null, null);
        ISWTObservableValue btnRegPreferenteNoObserveSelectionObserveWidget = SWTObservables.observeSelection((Control)this.btnRegPreferenteNo);
        UpdateValueStrategy strategy_4 = new UpdateValueStrategy();
        strategy_4.setConverter((IConverter)new BooleanNegativeConverter());
        UpdateValueStrategy strategy_5 = new UpdateValueStrategy();
        strategy_5.setConverter((IConverter)new BooleanNegativeConverter());
        bindingContext.bindValue((IObservableValue)btnRegPreferenteNoObserveSelectionObserveWidget, modeloDatosPagoLocalExteriorpagoRegimenFiscalObserveValue, strategy_4, strategy_5);
        bindingContext = this.compFiscalidad.initDataBindingsFiscaldiad(bindingContext, (ObjetoModelo)this.modeloDatos);
        return bindingContext;
    }
}

